/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.dcc;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.DccException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chat {
    private static final Logger log = LogManager.getLogger(Chat.class);
    protected User user;
    protected BufferedReader bufferedReader;
    protected BufferedWriter bufferedWriter;
    protected Socket socket;
    protected boolean finished;

    protected Chat(User user, Socket socket, Charset encoding) throws IOException {
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null");
        Preconditions.checkNotNull((Object)socket, (Object)"Socket cannot be null");
        Preconditions.checkNotNull((Object)encoding, (Object)"Encoding cannot be null");
        this.user = user;
        this.socket = socket;
        this.bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), encoding));
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), encoding));
    }

    public String readLine() throws IOException {
        if (this.finished) {
            throw new DccException(DccException.Reason.CHAT_NOT_CONNECTED, this.user, "Chat has already finished");
        }
        String line = this.bufferedReader.readLine();
        if (PircBotX.INFO_LEVEL != null && PircBotX.VERY_VERBOSE) {
            log.log(PircBotX.INFO_LEVEL, "<<<" + line);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLine(String line) throws IOException {
        Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null");
        if (this.finished) {
            throw new DccException(DccException.Reason.CHAT_NOT_CONNECTED, this.user, "Chat has already finished");
        }
        BufferedWriter bufferedWriter = this.bufferedWriter;
        synchronized (bufferedWriter) {
            if (PircBotX.INFO_LEVEL != null && PircBotX.VERY_VERBOSE) {
                log.log(PircBotX.INFO_LEVEL, ">>>" + line);
            }
            this.bufferedWriter.write(line + "\r\n");
            this.bufferedWriter.flush();
        }
    }

    public void close() throws IOException {
        if (this.finished) {
            throw new DccException(DccException.Reason.CHAT_NOT_CONNECTED, this.user, "Chat has already finished");
        }
        this.finished = true;
        this.socket.close();
    }

    public User getUser() {
        return this.user;
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

